%dw 2.0
output application/json

var monitor = vars.monitor default {}
var transactionId = correlationId default uuid()
var alert = payload default {}

fun getPriority(priority: String) = (
    priority match {
	    case "INFO" -> "INFO"
	    case "WARNING" -> "WARN"
	    case "ERROR" -> "ERROR"
	    case "FATAL" -> "ERROR"
	    else -> "INFO"
	}
)
---
{
    domain: vars.appName,
  	message: (vars.monitorDefinition.prefix default "NFX-ALERT: ") ++ (vars.alertMessage default "N/A"),
  	transactionId: transactionId,
  	priority: monitor.priority default Mule::p("notifications.defaults.priority"),
  	customProperties: {
        environment: vars.environmentName default Mule::p("anypoint.defaults.environmentName"),
    	organization: vars.organizationName default Mule::p("anypoint.defaults.organizationName"),
    	processName: vars.flowName default "",
    	threshold: monitor.threshold as String default "0",
    	maxThreshold: payload.maxThreshold,
    	pollingInterval: monitor.pollingInterval as String default "0",
    	intervalBetweenOccurrences: monitor.intervalBetweenOccurrences as String default "0",
        monitorName: vars.monitorDefinition.name default (monitor.alias default ""),
        destination: payload.destination,
    	startDate: payload.startDate,
    	endDate: payload.endDate,
	    last: write((payload.last default {}), "application/json"),
        timestamp: now()
  	}
}