%dw 2.0
output application/java

var monitorDefinition = vars.monitorDefinition default {}
var monitor = vars.monitor default {}
var usageData = (payload default [])

// Monitor threshold
var threshold = monitor.threshold as Number default 1
var billableUnitCount = sum(payload.billableUnitCount) default 0
var apiRequestCount = sum(payload.apiRequestCount) default 0
---
{
    startDate: min(usageData.timestamp) default null,
    endDate: max(usageData.timestamp) default null,
    triggerIt: ((billableUnitCount >= threshold)),
    threshold: threshold,
    billableUnitCount: billableUnitCount,
    apiRequestCount: apiRequestCount,
    last: usageData[0] default {}
}