%dw 2.0
output application/java

var monitorDefinition = vars.monitorDefinition default {}
var monitor = vars.monitor default {}
var messages = (payload.messagesReceived default [])

// Monitor threshold
var threshold = monitor.threshold as Number default 10

// How long before we send alert
var intervalBetweenOccurrences = monitor.intervalBetweenOccurrences as Number default 60
 
var intervalBetweenOccurrencesPercentage = ((sizeOf(messages) * 100) / intervalBetweenOccurrences) default 100
var accuracyPercentage = 90.0
var gteList = (messages) filter ($.value > threshold)
var lteList = (messages) filter ($.value <= threshold)
var gteCount = sizeOf(gteList)
var lteCount = sizeOf(lteList)
---
{
    destination: payload.destination,
    startDate: max(messages.date) default null,
    endDate: min(messages.date) default null,
    triggerIt: (gteCount == 0 and (intervalBetweenOccurrencesPercentage >= accuracyPercentage)),
    negatives: gteList,
    maxThreshold: max(lteList.value default []) default 0,
    threshold: threshold,
    last: messages[0] default {}
}