%dw 2.0
output application/java

var monitorDefinition = vars.monitorDefinition default {}
var monitor = vars.monitor default {}
var messages = (payload.messages default [])

// Monitor threshold
var threshold = monitor.threshold as Number default 10

// How long before we send alert
var intervalBetweenOccurrences = monitor.intervalBetweenOccurrences as Number default 60
var intervalBetweenOccurrencesPercentage = ((sizeOf(messages) * 100) / intervalBetweenOccurrences) default 100
var accuracyPercentage = 90.0

var messagesOut = sum(payload.messagesSent.value default []) default 0
var messagesIn = sum(payload.messagesReceived.value default []) default 0
var messagesAcked = sum(payload.messagesAcked.value default []) default 0

var dequeueRate = if (messagesOut > 0) (((messagesIn * 100) / messagesOut) default 100) else 100
---
{
    destination: payload.destination,
    startDate: max(messages.date) default null,
    endDate: min(messages.date) default null,
    triggerIt: ((messagesOut > 0 and (dequeueRate <= threshold)) and (intervalBetweenOccurrencesPercentage >= accuracyPercentage)),
    messagesAcked: messagesAcked,
    messagesProduced: messagesOut,
    messagesConsumed: messagesIn,
    dequeueRate: dequeueRate as String {format: "0.00", roundMode:"HALF_UP"} as Number default 0,
    threshold: threshold
}