%dw 2.0
output application/java

var monitorDefinition = vars.monitorDefinition default {}
var monitor = vars.monitor default {}
var freshMessages = (vars.messages default [])
var existingMessages = (payload default [])

// Monitor threshold
var threshold = monitor.threshold as Number default 1

// How long before we send alert
var intervalBetweenOccurrences = monitor.intervalBetweenOccurrences as Number default 60

var staleMessages = ((freshMessages default []) filter ((existingMessages.headers.messageId  default []) contains ($.headers.messageId)))
---
{
    destination: vars.destination,
    startDate: max(staleMessages.headers.created) default null,
    endDate: min(staleMessages.headers.created) default null,
    triggerIt: ((not isEmpty(staleMessages)) and (sizeOf(staleMessages) >= threshold)),
    staleMessages: staleMessages,
    threshold: threshold
}