%dw 2.0
output application/java

var monitorDefinition = vars.monitorDefinition default {}
var monitor = vars.monitor default {}
var messages = (payload.messages default [])

// Monitor threshold
var threshold = monitor.threshold as Number default 10

// How long before we send alert
var intervalBetweenOccurrences = monitor.intervalBetweenOccurrences as Number default 60

var intervalBetweenOccurrencesPercentage = ((sizeOf(messages) * 100) / intervalBetweenOccurrences) default 100
var accuracyPercentage = 90.0
var gteList = (messages) filter ($.value >= threshold)
var lteList = (messages) filter ($.value < threshold)
var gteCount = sizeOf(gteList)
var lteCount = sizeOf(lteList)
---
{
    destination: payload.destination,
    startDate: max(messages.date) default null,
    endDate: min(messages.date) default null,
    //parsed: parseStatsDate("2023-03-03T19:15:00.000+00:00"),
    //intervalBetweenOccurrencesPercentage: intervalBetweenOccurrencesPercentage
    //lteCount: sizeOf(lteList),
    //gteCount: sizeOf(gteList),
    triggerIt: (lteCount == 0 and (intervalBetweenOccurrencesPercentage >= accuracyPercentage)),
    negatives: lteList,
    threshold: threshold,
    maxThreshold: max(gteList.value default []) default 0,
    last: messages[0] default {}
}