%dw 2.0
output application/java

var startDate = vars.startDate
var endDate = vars.endDate
var events = (payload default []) orderBy (-$.timestamp)
---
{
    destinations: (flatten(events.objects default []) map ($.objectName)) distinctBy ($),
    startDate: startDate,
    endDate: endDate,
    triggerIt: (not isEmpty(payload)),
    messages: events map (event) -> (
        (event.payload.userName default "") ++ " performed " ++ (event.action default "") ++ " '" ++ (event.payload.objectName default "") ++ "' action at " ++ (((event.timestamp/1000) as DateTime default "") as String {format:"yyyy-MM-dd'T'HH:mm:ss"} default "")
    ),
    last: events[0] default null
}