%dw 2.0
output application/java

var monitor = vars.monitor default {}

// Period which defaults to 60 seconds
var period = vars.period default (Mule::p("anypoint.api.mq.stats.queues.queue.defaults.period"))

// How long before we send alert
var intervalBetweenOccurrences = monitor.intervalBetweenOccurrences as Number default 60
 
// Weird MQ Stats 5 minutes delay
var cloudhubDelay = (Mule::p("anypoint.api.mq.stats.queues.queue.defaults.dateDelay") as Number)

var intervalBetweenOccurrencesPeriod = ("PT" ++ ((intervalBetweenOccurrences + cloudhubDelay) as String default "1") ++ "M") as Period

var endDate = now()

fun getStartDate(endDate: DateTime) = (
    (endDate - intervalBetweenOccurrencesPeriod)
)
fun formatDate(dt: DateTime) = (
    dt as String{format: "EEE, dd MMM yyyy HH:mm:ss z"}
)
fun parseStatsDate(dtStr: String) = (
    dtStr as DateTime {format: "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}
)
---
{
    queueName: payload.queueId,
    startDate: formatDate(getStartDate(endDate)), 
    endDate: formatDate(endDate),
    period: period
}