%dw 2.0
output application/java
---
[
    {
        "name": "NFX-AMQ Queue Depth",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: Queue Depth",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}-\${environment}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} \${threshold}) has triggered alert for queue \${destination} organization \${organization} and environment \${environment} using:\n\nMonitor threshold                     : \${threshold}\nMax threshold detected           : \${maxThreshold}\nPolling Interval                           : \${pollingInterval}\nInterval Between Occurrences: \${intervalBetweenOccurrences}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\n\nLast Value:\n\${last}"
            }
        ]
    },
    {
        "name": "NFX-AMQ Changes Detected",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: MQ Changes Detected",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}-\${environment}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} has triggered alert for organization \${organization} and environment \${environment}:\n\n\${description}\n\nMonitor Details:\n\nAffected Destinations               : \${destinations}\nPolling Interval                           : \${pollingInterval}\nInterval Between Occurrences: \${intervalBetweenOccurrences}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\n\nLast Value:\n\${last}"
            }
        ]
    },
    {
        "name": "NFX-AMQ Dequeue Rate",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: Dequeue Rate",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}-\${environment}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} \${threshold}) has triggered alert for queue \${destination} organization \${organization} and environment \${environment} using:\n\nMonitor threshold                     : \${threshold}\nDequeue rate.                            : \${dequeueRate}\nPolling Interval                           : \${pollingInterval}\nInterval Between Occurrences: \${intervalBetweenOccurrences}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\nMessages Acked                         : \${messagesAcked}\nMessages Produced                   : \${messagesProduced}\nMessages Consumed                 : \${messagesConsumed}"
            }
        ]
    },
    {
        "name": "NFX-AMQ Queue In-Flight Depth",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: Queue In-Flight Depth",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}-\${environment}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} \${threshold}) has triggered alert for queue \${destination} organization \${organization} and environment \${environment} using:\n\nMonitor threshold                     : \${threshold}\nMax threshold detected           : \${maxThreshold}\nPolling Interval                           : \${pollingInterval}\nInterval Between Occurrences: \${intervalBetweenOccurrences}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\n\nLast Value:\n\${last}"
            }
        ]
    },
    {
        "name": "NFX-AMQ Queue Messages Sent",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: Queue Messages Sent",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}-\${environment}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} \${threshold}) has triggered alert for queue \${destination} organization \${organization} and environment \${environment} using:\n\nMonitor threshold                     : \${threshold}\nMax threshold detected           : \${maxThreshold}\nPolling Interval                           : \${pollingInterval}\nInterval Between Occurrences: \${intervalBetweenOccurrences}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\n\nLast Value:\n\${last}"
            }
        ]
    },
    {
        "name": "NFX-AMQ Queue Messages Received",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: Queue Messages Received",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}-\${environment}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} \${threshold}) has triggered alert for queue \${destination} organization \${organization} and environment \${environment} using:\n\nMonitor threshold                     : \${threshold}\nMax threshold detected           : \${maxThreshold}\nPolling Interval                           : \${pollingInterval}\nInterval Between Occurrences: \${intervalBetweenOccurrences}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\n\nLast Value:\n\${last}"
            }
        ]
    },
    {
        "name": "NFX-AMQ Usage: Billable Unit Count",
        "severity": "INFO",
        "enabled": true,
        "productName": "runtime-manager",
        "condition": {
            "text": "NFX-ALERT: Monthly Billable Unit",
            "priority": "ALL",
            "resources": [
                "*"//vars.appName
            ],
            "type": "application-notification",
            "resourceType": "cloudhub-application"
        },
        "actions": [
            {
                "subject": "\${severity}: \${message}",
                "type": "email",
                "emails": ["mfedorov@netflexity.com"],
                "content": "You are receiving this alert because monitor (\${monitorName} \${threshold}) has triggered alert for organization \${organization} using:\n\nMonitor threshold                     : \${threshold}\nBillable Unit Count                         : \${billableUnitCount}\nAPI Request Count                         : \${apiRequestCount}\nStart Date                                    : \${startDate}\nEnd Date                                      : \${endDate}\n\nLast Value:\n\${last}"
            }
        ]
    }
]