%dw 2.0
output application/json

fun splitByValue (inputData: Array) = (
    (inputData reduce ((item, report = []) ->
        do {
            var lastIndex = (sizeOf(report)-1) default -0
            var lastItem = report[lastIndex] default {}
            ---
            if (isEmpty(lastItem) or lastItem.messages != item.value)
                report + {
                    messages: item.value,
                    fromDate: item.date,
                    toDate: item.date
                }
            else if (lastIndex == 0)
                [(report[0] - "fromDate") ++ {
                    fromDate: item.date
                }]
            else
                report [0 to (lastIndex - 1)] + ((lastItem - "fromDate") ++ {
                    fromDate: item.date
                })
        }
    )) 
)
---
((payload default[]) map (dest) -> {
    destination: dest.destination,
    segments: splitByValue(dest.messages default []) orderBy ($.fromDate)
})
