%dw 2.0
output application/java
fun getGranularity(pollingIntervalMinutes: Number): Number = (
    // Second-level data points: Retained for the past 3 hours.
    if (pollingIntervalMinutes < 180) (1 * 60)
    // Minutely data points: Retained for the past 15 days.
    else if (pollingIntervalMinutes < 21600) (5 * 60)
    // 5-minute data points: Retained for the past 63 days.
    else if(pollingIntervalMinutes < 86400) (15 * 60)
    // Hourly data points: Retained for the past 15 months.
    else if (pollingIntervalMinutes < 656640) (5 * (60 * 60))
    else (86400)
)
---
getGranularity(payload as Number default 60)