%dw 2.0
output application/java

// Period which defaults to 60 seconds
var period = Mule::p("anypoint.api.mq.stats.queues.queue.defaults.period") as Number

// Weird MQ Stats 5 minutes delay
var cloudhubDelay = (Mule::p("anypoint.api.mq.stats.queues.queue.defaults.dateDelay") as Number)

var pollingPeriodInMinutes = 60
var startPeriod = ("PT" ++ ((pollingPeriodInMinutes + cloudhubDelay) as String default "1") ++ "M") as Period
var endDate = now()

fun getStartDate(endDate: DateTime) = (
    (endDate - startPeriod)
)
fun formatDate(dt: DateTime) = (
    dt as String{format: "EEE, dd MMM yyyy HH:mm:ss z"}
)
---
{
    startDate: formatDate(getStartDate(endDate)), 
    endDate: formatDate(endDate),
    period: period
}