/*
 * Decompiled with CFR 0.152.
 */
package com.netflexity.software.qflex.mule.license;

import com.netflexity.software.qflex.mule.common.KeyLoader;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LicenseService {
    public static String decode(String encodedLicense, String publicKeyString) {
        try {
            int chunk;
            Key publicKey = KeyLoader.createRSAPublicKeySpec(KeyLoader.decodePEMFormatFromString(publicKeyString));
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            rsaCipher.init(2, publicKey);
            byte[] content = Base64.getDecoder().decode(encodedLicense);
            int chunkSize = rsaCipher.getBlockSize();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int offset = 0;
            do {
                chunk = offset + chunkSize < content.length ? chunkSize : content.length - offset;
                byte[] chunkData = new byte[chunk];
                System.arraycopy(content, offset, chunkData, 0, chunk);
                byte[] decrypted = rsaCipher.doFinal(chunkData);
                baos.write(decrypted, 0, decrypted.length);
            } while ((offset += chunk) < content.length);
            byte[] ba = baos.toByteArray();
            int rlen = ba.length;
            while (ba[rlen - 1] == 0) {
                --rlen;
            }
            byte[] baTrimmed = Arrays.copyOf(ba, rlen);
            return new String(baTrimmed);
        }
        catch (Exception e) {
            return null;
        }
    }
}

