/*
 * Decompiled with CFR 0.152.
 */
package com.netflexity.software.qflex.mule.common;

import com.netflexity.software.qflex.mule.common.LicenseException;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class KeyLoader {
    public static Key createRSAPublicKeySpec(byte[] keyBytes) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(keyBytes);
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LicenseException("RSA algorithm isn't supported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new LicenseException("Invalid Public Key", e);
        }
    }

    public static Key generateRSAPrivateKey(byte[] keyBytes) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LicenseException("RSA algorithm isn't supported.");
        }
        catch (InvalidKeySpecException e) {
            throw new LicenseException("Invalid Private Key");
        }
    }

    public static Key getPublicKeyFromX509Certificate(byte[] certificateBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificateBytes));
        return certificate.getPublicKey();
    }

    public static byte[] decodePEMFormatFromString(String pemString) {
        int indexFooterStart;
        int indexHeaderStart = pemString.indexOf("-----BEGIN");
        if (indexHeaderStart >= 0) {
            int indexHeaderEnd = pemString.indexOf("-----", indexHeaderStart);
            if (indexHeaderEnd < 0) {
                throw new LicenseException("Wrong PEM format");
            }
            int indexNewLine = pemString.indexOf("\n", indexHeaderEnd);
            if (indexNewLine < 0) {
                throw new LicenseException("Wrong PEM format");
            }
            pemString = pemString.substring(indexNewLine + 1);
        }
        if ((indexFooterStart = pemString.indexOf("-----END")) >= 0) {
            pemString = pemString.substring(0, indexFooterStart);
        }
        pemString = pemString.replace("\r", "").replace("\n", "");
        try {
            return Base64.getDecoder().decode(pemString);
        }
        catch (Exception e) {
            throw new LicenseException("Wrong PEM format");
        }
    }
}

