/*
 * Decompiled with CFR 0.152.
 */
package com.netflexity.mule.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

public class QueueDepthActivityChart {
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ENGLISH);

    public static byte[] toChart(List<Map<String, ?>> queueStatsByQueue, String title, int width, int height) {
        TimeSeriesCollection timeSeriesCollection = QueueDepthActivityChart.createTimeSeries(queueStatsByQueue);
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Date", (String)"Messages", (XYDataset)timeSeriesCollection, (boolean)true, (boolean)true, (boolean)false);
        chart.setTitle(new TextTitle(title, new Font("Serif", 1, 18)));
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        chart.setBorderVisible(false);
        Plot plot = chart.getPlot();
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(false);
        xyplot.setRangeCrosshairVisible(false);
        xyplot.setRangeGridlinesVisible(false);
        xyplot.setDomainGridlinesVisible(false);
        XYItemRenderer r = xyplot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsJPEG((OutputStream)out, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)new ChartRenderingInfo((EntityCollection)new StandardEntityCollection()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private static TimeSeriesCollection createTimeSeries(List<Map<String, ?>> queueStatsByQueue) {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        for (Map<String, ?> statRecord : queueStatsByQueue) {
            String destination = (String)statRecord.get("destination");
            TimeSeries timeSeries = new TimeSeries((Comparable)((Object)destination));
            List messages = (List)statRecord.get("messages");
            for (Map message : messages) {
                String dateStr = (String)message.get("date");
                Integer valueInt = (Integer)message.get("value");
                if (valueInt == null) {
                    valueInt = 1;
                }
                Double value = valueInt.doubleValue();
                try {
                    Date date = formatter.parse(dateStr);
                    timeSeries.addOrUpdate(new TimeSeriesDataItem((RegularTimePeriod)new FixedMillisecond(date), (Number)value));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            timeSeriesCollection.addSeries(timeSeries);
        }
        return timeSeriesCollection;
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("America/New_York"));
    }
}

