/*
 * Decompiled with CFR 0.152.
 */
package com.netflexity.mule.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class QueueDepthActivityBarChart {
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ENGLISH);

    public static byte[] toChart(List<Map<String, ?>> queueStatsByQueue, String title, int width, int height) {
        TimeTableXYDataset timeTableXYDataset = QueueDepthActivityBarChart.createTimeTableXYDataset(queueStatsByQueue);
        DateAxis dateAxis = new DateAxis("Date");
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        dateAxis.setLowerMargin(0.01);
        dateAxis.setUpperMargin(0.01);
        NumberAxis numberAxis = new NumberAxis("Messages");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setUpperMargin(0.1);
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer(0.15);
        stackedXYBarRenderer.setDrawBarOutline(false);
        stackedXYBarRenderer.setDefaultItemLabelGenerator((XYItemLabelGenerator)new StandardXYItemLabelGenerator());
        stackedXYBarRenderer.setDefaultPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER));
        stackedXYBarRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0} : {1} = {2}", (DateFormat)new SimpleDateFormat("MM-dd-yyyy HH:mm"), (NumberFormat)new DecimalFormat("0")));
        XYPlot xyplot = new XYPlot((XYDataset)timeTableXYDataset, (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)stackedXYBarRenderer);
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(false);
        xyplot.setRangeCrosshairVisible(false);
        xyplot.setRangeGridlinesVisible(false);
        xyplot.setDomainGridlinesVisible(false);
        JFreeChart chart = new JFreeChart((Plot)xyplot);
        chart.setTitle(new TextTitle(title, new Font("Serif", 1, 18)));
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        chart.removeLegend();
        chart.setTextAntiAlias(RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        LegendTitle legendTitle = new LegendTitle((LegendItemSource)xyplot);
        legendTitle.setBackgroundPaint((Paint)Color.white);
        legendTitle.setFrame((BlockFrame)new BlockBorder());
        legendTitle.setPosition(RectangleEdge.BOTTOM);
        chart.addSubtitle((Title)legendTitle);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsJPEG((OutputStream)out, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)new ChartRenderingInfo((EntityCollection)new StandardEntityCollection()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private static TimeTableXYDataset createTimeTableXYDataset(List<Map<String, ?>> queueStatsByQueue) {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        for (Map<String, ?> statRecord : queueStatsByQueue) {
            String destination = (String)statRecord.get("destination");
            List messages = (List)statRecord.get("messages");
            for (Map message : messages) {
                String dateStr = (String)message.get("date");
                Integer valueInt = (Integer)message.get("value");
                if (valueInt == null) {
                    valueInt = 1;
                }
                Double value = valueInt.doubleValue();
                try {
                    Date date = formatter.parse(dateStr);
                    timeTableXYDataset.add((TimePeriod)new FixedMillisecond(date), value.doubleValue(), (Comparable)((Object)destination));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return timeTableXYDataset;
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("America/New_York"));
    }
}

